library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

-- de2_wm8731_audio_in : generate clock and get the samples from device

entity de2_wm8731_audio_in is
port (
    clk : in std_logic;       --  Audio CODEC Chip Clock AUD_XCK (18.43 MHz)
    reset_n : in std_logic;
    data_out : out std_logic_vector(15 downto 0);
    audio_req : out std_logic;

    -- Audio interface signals
	AUD_ADCLRCK  : out std_logic;   --    Audio CODEC ADC LR Clock
    AUD_ADCDAT   : in  std_logic;   --    Audio CODEC ADC Data
    AUD_BCLK     : inout std_logic  --    Audio CODEC Bit-Stream Clock
  );
end  de2_wm8731_audio_in;


architecture Behavioral of  de2_wm8731_audio_in is     

    signal lrck : std_logic;
    signal bclk : std_logic;
    signal xck : std_logic;
    
    signal lrck_divider : std_logic_vector (7 downto 0); 
    signal bclk_divider : std_logic_vector (3 downto 0);
    
    signal set_bclk : std_logic;
    signal set_lrck : std_logic;
    signal lrck_lat : std_logic;
	signal clr_bclk : std_logic;
    signal datain : std_logic;

    signal shift_in : std_logic_vector ( 15 downto 0);   
	signal shift_counter : integer := 15;
	
	-- Second clock divider
	
	signal lrck_div2 : std_logic_vector (11 downto 0);
	--signal set_lrck2 : std_logic;
	signal bclk_divider2: std_logic_vector (7 downto 0);
	
begin
    -- LRCK divider 
    -- Audio chip main clock is 18.432MHz / Sample rate 48KHz
    -- Divider is 18.432 MHz / 48KHz = 192 (X"C0")
    -- Left justify mode set by I2C controller

    process(clk, reset_n) -- loops Another divider to slow down the LRclk
    begin
        if ( reset_n = '0' ) then 
            lrck_div2 <= (others => '0');
        elsif ( clk'event and clk='1' ) then
            if ( lrck_div2 = X"47F")  then     -- 8FF = 900 - 1    
                lrck_div2 <= X"000";
            else 
                lrck_div2 <= lrck_div2 + '1';
            end if;
        end if;
    end process;

    process(clk, reset_n) -- loops second bclk_divider -- we only need one of the 2
    begin
        if ( reset_n = '0' ) then 
            bclk_divider2 <= (others => '0');
        elsif ( clk'event and clk='1' ) then
            if ( bclk_divider2 = X"47" or set_lrck = '1')  then    -- 8F = 90-1
                bclk_divider2 <= X"00";
            else 
                bclk_divider2 <= bclk_divider2 + '1';
            end if;
        end if;
    end process;
    
    process ( lrck_div2 ) 
    begin
        if ( lrck_div2 = X"47F") then
            set_lrck <= '1';
        else
            set_lrck <= '0';
        end if;
    end process;

-- Here we just have to change set_lrck to set_lrck2 to change the Sampling rate to 8kHz
    
    process ( clk, reset_n) 
    begin
        if ( reset_n = '0') then
            lrck <= '0';
        elsif ( clk 'event and clk = '1') then 
            if ( set_lrck = '1') then 
                lrck <= not lrck;
            end if;
        end if;
    end process;
 
    -- BCLK divider    
    process ( bclk_divider2 ) 
    begin
        if ( bclk_divider2  = X"23") then -- x5 -- why 5 and B?
            set_bclk <= '1';                      
        else
            set_bclk <= '0';
        end if;      

        if ( bclk_divider2 = X"47") then -- xB
            clr_bclk <= '1';                      
        else
            clr_bclk <= '0';
        end if;              
    end process;
    
    process ( clk, reset_n) 
    begin
        if ( reset_n = '0') then
            bclk <= '0';
        elsif ( clk 'event and clk = '1') then 
            if ( set_lrck = '1' or clr_bclk = '1') then
                bclk <= '0';
            elsif ( set_bclk = '1') then 
                bclk <= '1';
            end if;
        end if;
    end process;

	process (clk)
	begin
	if ( clk 'event and clk = '1') then
		if (set_bclk = '1') then
			shift_in(shift_counter) <= AUD_ADCDAT;
			if (shift_counter = 0) then
				shift_counter <= 15;
			else
				shift_counter <= shift_counter - 1;
			end if;
		end if;
	end if;
	end process;
	
	process(clk)
    begin
        if ( clk'event and clk='1' ) then -- why??
            lrck_lat <= lrck;
        end if;
    end process;

--	process (clk) 
--    begin
--        if ( clk'event and clk = '1') then 
--            --if (( lrck_lat = '1' and lrck = '0') or ( lrck_lat = '0' and lrck = '1')) then
--            if(set_lrck <= '1') then  
--				audio_req <= '1';
--            else
--                audio_req <= '0';
--            end if;
--        end if;
--    end process;
    -- Audio data shift output
    process ( clk, reset_n) 
    begin
        if ( clk 'event and clk = '1') then 
            if ( set_lrck = '1') then
                data_out <= shift_in;
				audio_req <= '1';
			else
				audio_req <='0';
				
            end if;
        end if;
    end process;

    -- Audio outputs
    
    AUD_BCLK     <= bclk; 
	AUD_ADCLRCK	 <= lrck;             

end architecture;


